/**
 * Slam-It eBay Sniping Button
 * 
 * This script is part of a Firefox extension that automatically adds a custom button 
 * on specific eBay pages. When the button is clicked, it opens a new window to our
 * website and allows a snipe to be added.
 * 
 * @version: 1.0
 * @license: MIT License
 * @copyright: Copyright (c) 2024 BidSlammer LLC.
 */

// Get eBay item number
var item_no = parseEbayItemNumber();
var time_interval = 240;
const slamitUrl = 'http://localhost:8000/user/slamit/?url=' + encodeURIComponent(location.href);

// Execute code only if valid item number was found
if (item_no) {

	// Interval function to check for the existence of the button
	var time_elapsed = 0;
	const intervalId = setInterval(function() {
		time_elapsed += time_interval;

		// Check if the button exists
		const targetButton = document.querySelector('#slamitButton');
		if (! targetButton) {
			console.log('Button not found. Adding.');
			clearInterval(intervalId);
			addButton();

			// Stop trying to add button after 10 seconds
			if (time_elapsed >= 10000) {
				clearInterval(intervalId);
			}
		}
	}, time_interval);
 }

 function addButton(btn_id) {

	const existingBidButton = document.querySelector('#bidBtn_btn');

	if (existingBidButton) {
		console.log('target button located!');
		const newButton = document.createElement('button');
		newButton.textContent = 'Slam It!';
		newButton.onclick = function() {
			openCustomWindow();
		};

		// Apply button styling
		newButton.id = 'slamitButton';
		newButton.style.marginTop = '5px';
		newButton.style.backgroundImage = 'linear-gradient(to right, #444444, #FF0000)'; // Gradient background
		newButton.style.border = '2px solid #FF0000';
		newButton.style.color = '#FFFFFF';
		newButton.style.fontWeight = 'bold';
		newButton.style.borderRadius = '25px';
		newButton.style.width = '100%';
		newButton.style.height = '50px';
		newButton.style.fontSize = '12pt';
		newButton.style.cursor = 'pointer'; // Pointer cursor on hover

		existingBidButton.parentNode.insertBefore(newButton, existingBidButton.nextSibling);
	}
	else {
		//console.log('Target button not found.');
	}
}

function openCustomWindow() {
	const width = 320;
	const height = 350;
	const top = window.screenY + 150;  // Updated to use window.screenY
	const left = window.screenX + (window.innerWidth / 1.75); // Updated to use window.screenX
	const features = `popup=yes,width=${width},height=${height},top=${top},left=${left},resizable=no,scrollbars=no`;
	const newWindow = window.open(slamitUrl, 'SlamIt', features);
	if (newWindow) {
		newWindow.focus();
	}
}

function parseEbayItemNumber() {
	const url = window.location.href;
	const pattern = /\/(\d{10,14})\b/;
	const match = url.match(pattern);

	if (match && match[1])
		return match[1];
	else
		return null;
}

